require( "scripts/style.lua" )


kPlayerNameY = 150;
kScoreY = 200;
kYourPFAccountY = 255;
kAccountNameY = 275;
kPasswordY = 310;
kRememberY = 350;

kPrivacyLabel = 'privacy';
if (IsEnabled(kHiscoreAnonymous)) then
	kPrivacyLabel = 'privacy_info';
end

function SwitchModes( submit )
    
    local localHS = IsEnabled(kHiscoreLocalOnly);
    local anonHS = IsEnabled(kHiscoreAnonymous);
    local fullHS = (not localHS) and (not anonHS);

    if submit then
        DebugOut( "SwitchModes true "..tostring(localHS).." "..tostring(anonHS));
    else
        DebugOut( "SwitchModes false "..tostring(localHS).." "..tostring(anonHS));
    end

    EnableWindow("header",not submit);
    EnableWindow("headershadow",not submit);
    EnableWindow("playertext", not submit);
    EnableWindow("yourscore", not submit);
    EnableWindow("eligiblescorebox", not submit);
    EnableWindow("yourpfaccount", not submit and fullHS);
    EnableWindow("nametext", not submit and fullHS);
    EnableWindow("passtext", not submit and fullHS);

    EnableWindow("nameeditbox", not submit );
    EnableWindow("accounteditbox", not submit and fullHS);
    EnableWindow("passeditbox", not submit and fullHS);
    EnableWindow("remember", not submit and fullHS);

    EnableWindow("submittoserver", not submit);
    EnableWindow("submitcancel", not submit);
    EnableWindow("submitconnect", submit);

end

MakeDialog
{
    name="hiscoresubmitscreen",
    Bitmap
    { 
        image="ui/surfaces/largedialog",	
        x=kCenter,
        y=kCenter,

        SetStyle(CreateTextStyle(FontGame, 35, BlackColor)),
        Text
        {
            name = "header",
            x=0,y=40,
            flags = kHAlignCenter + kVAlignTop,
            label = "submitglobal"
        };
        
        SetStyle(CreateTextStyle(FontGame, 18, BlackColor)),
        Text
        {
            name = "playertext",
            x=0,y=kPlayerNameY + 7,w=130,h=kMax,
            flags = kHAlignRight + kVAlignTop,
            label = "playerlabel"
        };
        
        SetStyle(CreateTextStyle(FontGame, 18, BlackColor)),
        Text
        {
            name = "yourscore",
            x=0,y=kScoreY + 7,w=130,h=kMax,
            flags = kHAlignRight + kVAlignTop,
            label = "scorelabel"
        };
        
        SetStyle(CreateTextStyle(FontGame, 14, BlackColor)),
        Text
        {
            name = "yourpfaccount",
            x=120,y=kYourPFAccountY,w=kMax-80,h=kMax,
            flags = kHAlignCenter + kVAlignTop,
            label = "yourpfaccount"
        };
        
        SetStyle(CreateTextStyle(FontGame, 18, BlackColor)),
        Text
        {
            name = "nametext",
            x=0,y=kAccountNameY + 7,w=130,h=kMax,
            flags = kHAlignRight + kVAlignTop,
            label = "namelabel"
        };
        
        SetStyle(CreateTextStyle(FontGame, 18, BlackColor)),
        Text
        {
            name = "passtext",
            x=0,y=kPasswordY + 7,w=130,h=kMax,
            flags = kHAlignRight + kVAlignTop,
            label = "passwordlabel"
        };
        
        SetStyle(CreateTextStyle(FontGame, 18, BlackColor)),
        Text
        {
            name = "submitconnect",
            x=90,y=40,w=kMax-90,h=kMax - 60,
            label = "connectingtoserver"
        };
        
        SetStyle(CreateTextStyle(FontGame, 18, BlackColor)),
        Text
        {
            font = ErrorFont,
            name = "submiterror",
            x=90,y=40,w=kMax-90,h=kMax - 60,
            label = "Error Message"
        };
        
        SetStyle(CreateTextStyle(FontGame, 14, BlackColor)),
        Text
        {
            x = 110, w = kMax-80,
            y = 400, h = 40,
            flags = kHAlignLeft + kVAlignTop,
            label = kPrivacyLabel
        };

        Bitmap
        {
            name="eligiblescorebox",
            image="ui/surfaces/textfield.png",
            x=135,
            y=kScoreY,

			SetStyle(CreateTextStyle(FontGame, 18, BlackColor)),
			Text
			{
				name = "eligiblescore",
				x=0,y=3,w=kMax,h=kMax,
				flags = kHAlignCenter + kVAlignCenter,
				label = gEligibleScore
			};
        };

        Bitmap
        {
            name="nameeditbox",
            image="ui/surfaces/textfield.png",
            x=135,
            y=kPlayerNameY,
            
            TextEdit
            {
                font = {FontGame, 18, BlackColor},
                name = "nameedit",
                label = gNameEdit,
                x=0,y=3,w=kMax,h=kMax,
                length=20,
                ignore = kIllegalNameChars
                
            };
        };
        
        Bitmap
        {
            name="accounteditbox",
            image="ui/surfaces/textfield.png",
            x=135,
            y=kAccountNameY,
            
            TextEdit
            {
                font = {FontGame, 18, BlackColor},
                name = "accountedit",
                label= gAccountEdit,
                x=0,y=3,w=kMax,h=kMax,
                length=20,
                ignore = kIllegalNameChars
            };
        };
        
        Bitmap
        {
            name="passeditbox",
            image="ui/surfaces/textfield.png",
            x=135,
            y=kPasswordY,
            
            TextEdit
            {
                font = { FontGame, 24, BlackColor },
                name = "passedit",
                label= gPassEdit,
                x=0,y=3,w=kMax,h=kMax,
                password = true,
                length=20
                
            };
        };
        
        SetStyle(CreateCheckButtonStyle(CheckboxButtonGraphics, NoButtonSound)),
        Button
        {
            x=110, y=kRememberY,
            name="remember",
            w=300,
            scale=0.5,
            drop = false,
            SetStyle(CreateTextStyle(FontGame, 18, BlackColor)),
            Text
            {
                name = "rememberlabel",
                x=25,y=10,
                w=300,h=25,
                flags = kHAlignLeft + kVAlignTop,
                label="rememberpfaccount",
            };
        };
        
        SetStyle(CreatePushButtonStyle(StandardButtonGraphics, DefaultButtonSound)),
        Button
        {
            x=kCenter-100, y=kMax-80,
            name="submittoserver",
            default= true, -- this should be the default button (on enter)
            command = 
                function()
                    name = GetLabel("nameedit");
                    account = GetLabel("accountedit");
                    pass = GetLabel("passedit");
                    remember = GetButtonToggleState("remember");
                    SubmitToServer(name,account,pass,remember);
                end,
                SetStyle(CreateTextStyle(FontGame, 22, WhiteColor)),
                CreateText(1,4,"submit", 0, 0),
                SetStyle(CreateTextStyle(FontGame, 22, BlackColor)),
                CreateText(0,0,"submit", 0, 0),
        },
        
        SetStyle(CreatePushButtonStyle(StandardButtonGraphics, DefaultButtonSound)),
        Button
        {
            x=kCenter+100, y=kMax-80,
            name="submitcancel",
            command = 
                function()
                    PopModal("hiscoresubmitscreen"); -- take off high score menu, restart game loop
                end,
            SetStyle(CreateTextStyle(FontGame, 22, WhiteColor)),
            CreateText(1,4,"cancel", 0, 0),
            SetStyle(CreateTextStyle(FontGame, 22, BlackColor)),
            CreateText(0,0,"cancel", 0, 0),
        };
        
        SetStyle(CreatePushButtonStyle(StandardButtonGraphics, DefaultButtonSound)),
        Button
        {
            x=kCenter, y=kMax-80,
            name="submiterrorok",
            command=
                function()
                    EnableWindow("submiterrorok",false);
                    EnableWindow("submiterror",false);
                    SwitchModes(false);
                end,
            SetStyle(CreateTextStyle(FontGame, 22, WhiteColor)),
            CreateText(1,4,"ok", 0, 0),
            SetStyle(CreateTextStyle(FontGame, 22, BlackColor)),
            CreateText(0,0,"ok", 0, 0),
        };
        Button
        {
            x=0,
            y=0,
            w=0,
            h=0,
            graphics={},
            name="privacybutton",
            command = 
                function()
                    if (IsEnabled(kHiscoreAnonymous)) then
                        DisplayDialog { 
                            "scripts/ok.lua", 
                            body ="privacy_anon",
                            title = ""
                        };
                    else
                        LaunchPrivacyPolicy();
                    end
                end
        };
    }
}

EnableWindow("submitconnect", false);
EnableWindow("submiterror",false);
EnableWindow("submiterrorok", false);
SetButtonToggleState('remember',gRemember);
SetFocus("nameedit");